!BossHP = $18E6|!addr
!BossHits = 12

!A = #$29
!B = #$38
!C = #$39
!D = #$44
!E = #$45
!F = #$46
!G = #$47
!H = #$48
!I = #$49
!J = #$54
!K = #$55
!L = #$56
!M = #$57
!N = #$58
!O = #$59
!P = #$D4
!Q = #$CE
!R = #$CF
!S = #$DE
!T = #$DF
!U = #$88
!V = #$89
!W = #$98
!X = #$99
!Y = #$C2
!Z = #$C3
!Ex = #$D2
!Qu = #$D3 


Init:
	LDA #$01		;\  Force Big Mario
	STA $19			;/

	REP   #$20 ; 16-bit A

	; Set transfer modes.
	LDA   #$3202
	STA   $4330 ; Channel 3
	LDA   #$3200
	STA   $4340 ; Channel 4

	; Point to HDMA tables.
	LDA   #Gradient1_RedGreenTable
	STA   $4332
	LDA   #Gradient1_BlueTable
	STA   $4342

	SEP   #$20 ; 8-bit A

	; Store program bank to $43x4.
	PHK
	PLA
	STA   $4334 ; Channel 3
	STA   $4344 ; Channel 4

	; Enable channels 3 and 4.
	LDA.b #%00011000
	TSB   $0D9F|!addr

	RTL ; <-- Can also be RTL.

; Data for the sprite tiles
FilledTiles:
    db $C0, $C1, $D0
EmptyTiles:
    db $E8, $E9, $F8

main:

;Glendaal Animation Frames
;AnimPhase Map
;00 = Crouch
;01 = Jump
;02 = SummonIce

;Anim Map
;Frame 00 = Crouch
;Frame 01 = Jump
;Frame 02 = SummonIce
;Frame 03-05 = WalkCycle



!AnimTimer = $18D8|!addr
!AnimPhase = $13E6|!addr






REP #$10
%maxtile(!G, #5, #$CB, #$30, #$00, "high")
%maxtile(!L, #12, #$CB, #$30, #$00, "high")
%maxtile(!E, #19, #$CB, #$30, #$00, "high")
%maxtile(!N, #26, #$CB, #$30, #$00, "high")
%maxtile(!D, #33, #$CB, #$30, #$00, "high")
%maxtile(!A, #40, #$CB, #$30, #$00, "high")
%maxtile(!A, #47, #$CB, #$30, #$00, "high")
%maxtile(!L, #54, #$CB, #$30, #$00, "high")
  ; X = tile currently being drawn
    ldx.w #$00
    ; Y = sprite tile offset into FilledTiles
    ldy.w #$00
    ; $00 = X position
    lda.b #$05
    sta.b $00
    ; Main loop
.loop:
    ; Compare to Boss HP
    cpx.w !BossHP
    ; Switch to empty tiles if necessary
    bne + : iny #3 : +
    ; Draw the tile
    phx
    %maxtile("FilledTiles,y", $00, #$D3, #%00111000, #$00, "high")
    plx
    ; Check if we're drawing the first tile, and switch to the second
    cpx.w #$00
    bne + : iny : +
    ; Check if we're drawing the next-to-last tile, and switch to the third
    cpx.w #!BossHits-2
    bne + : iny : +
    ; Increment position
    lda.b $00
    clc : adc.b #$07
    sta.b $00
    ; Check if we're done
    inx
    cpx.w #!BossHits
    bne .loop
    
SEP #$30
RTL

Gradient1_RedGreenTable:
db $04,$33,$53
db $06,$32,$52
db $06,$31,$51
db $06,$30,$50
db $06,$2F,$4F
db $06,$2E,$4E
db $06,$2D,$4D
db $06,$2C,$4C
db $06,$2B,$4B
db $07,$2A,$4A
db $06,$29,$49
db $06,$28,$48
db $06,$27,$47
db $06,$26,$46
db $06,$25,$45
db $06,$24,$44
db $06,$23,$43
db $06,$22,$42
db $06,$21,$41
db $6F,$20,$40
db $00

Gradient1_BlueTable:
db $04,$93
db $06,$92
db $06,$91
db $06,$90
db $06,$8F
db $06,$8E
db $06,$8D
db $06,$8C
db $06,$8B
db $07,$8A
db $06,$89
db $06,$88
db $06,$87
db $06,$86
db $06,$85
db $06,$84
db $06,$83
db $06,$82
db $06,$81
db $6F,$80
db $00



